# إعداد البحث في المصادر الخارجية

## 📋 نظرة عامة

تم إضافة ميزة البحث في المصادر الخارجية الموثوقة إلى النظام. هذه الميزة تسمح للنظام بالبحث في مصادر قانونية موثوقة على الإنترنت بالإضافة إلى القوانين المحلية.

## 🔧 الإعداد

### 1. الحصول على Google Custom Search API

1. اذهب إلى [Google Cloud Console](https://console.cloud.google.com/)
2. أنشئ مشروع جديد أو اختر مشروع موجود
3. فعّل **Custom Search API** من المكتبة
4. أنشئ **API Key**:
   - اذهب إلى "Credentials"
   - اضغط "Create Credentials" > "API Key"
   - احفظ الـ API Key

### 2. إنشاء Custom Search Engine

1. اذهب إلى [Google Custom Search](https://programmablesearchengine.google.com/)
2. اضغط "Add" لإنشاء محرك بحث جديد
3. أدخل المواقع الموثوقة (مثل):
   - `moj.gov.eg` (وزارة العدل المصرية)
   - `manshurat.gov.eg` (المنشورات الرسمية)
   - `alexu.edu.eg` (جامعة الإسكندرية - كلية الحقوق)
4. احفظ الـ Search Engine ID

### 3. إضافة المتغيرات إلى ملف `.env`

أضف المتغيرات التالية إلى ملف `.env` في مجلد `server/`:

```env
# Google Custom Search API
GOOGLE_SEARCH_API_KEY=your_api_key_here
GOOGLE_SEARCH_ENGINE_ID=your_search_engine_id_here
```

## ⚙️ كيف يعمل النظام؟

### متى يتم استخدام البحث الخارجي؟

- يتم البحث في المصادر الخارجية عندما:
  1. السؤال قانوني
  2. إما لا توجد مراجع محلية كافية **أو** السؤال معقد (أكثر من 50 حرف أو يحتوي على أسئلة معقدة)

### مصادر البحث

النظام يبحث في:
- المواقع الرسمية المصرية (moj.gov.eg, manshurat.gov.eg)
- المواقع الأكاديمية القانونية الموثوقة
- مصادر قانونية مصرية موثوقة أخرى

### عرض النتائج

- يتم عرض المصادر الخارجية في نهاية الإجابة
- يتم ربط المصادر بروابط مباشرة
- يتم عرض ملخص لكل مصدر

## 🔒 الأمان

- البحث محدود بالمواقع الموثوقة فقط
- يتم التحقق من أن النتائج متعلقة بالقانون المصري
- في حالة عدم توفر API keys، يعمل النظام بشكل طبيعي بدون البحث الخارجي

## 📝 ملاحظات

- البحث الخارجي اختياري - إذا لم تقم بإعداد API keys، سيعمل النظام بشكل طبيعي مع القوانين المحلية فقط
- يمكنك تخصيص المواقع التي يتم البحث فيها من خلال تعديل `searchQuery` في `externalSearchService.js`
- الحد الأقصى للنتائج الخارجية هو 3 نتائج لكل سؤال

## 🚀 البدء السريع

1. ثبت الحزم المطلوبة:
```bash
cd server
npm install
```

2. أضف المتغيرات إلى `.env`:
```env
GOOGLE_SEARCH_API_KEY=your_key
GOOGLE_SEARCH_ENGINE_ID=your_id
```

3. أعد تشغيل الخادم:
```bash
npm run dev
```

## ⚠️ تحذيرات

- تأكد من أن API keys محمية ولا يتم مشاركتها
- راقب استخدام API لتجنب تجاوز الحدود المجانية
- Google Custom Search API له حدود مجانية: 100 طلب يومياً

