# Qanonak Backend Server

Backend server for Qanonak legal chatbot application.

## Features

- User authentication (register, login)
- Chat history management (stores up to 10 chats per user)
- Groq AI integration for legal consultations
- MongoDB database integration
- JWT token-based authentication

## Setup

1. Install dependencies:
```bash
npm install
```

2. Create `.env` file (already created with default values):
```
PORT=5000
MONGODB_URI=mongodb+srv://devahmednady_db_user:odJURCMj9FAOvfHh@qanonak.oe1b0n0.mongodb.net/Qanonak
JWT_SECRET=your-super-secret-jwt-key-change-in-production
GROQ_API_KEY=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
GROQ_MODEL=llama-3.3-70b-versatile
```

3. Seed initial user:
```bash
npm run seed
```

This will create a user with:
- Email: nadyahmd88@gmail.com
- Password: user@123

4. Start the server:
```bash
# Development mode (with auto-reload)
npm run dev

# Production mode
npm start
```

## API Endpoints

### Authentication
- `POST /api/auth/register` - Register new user
- `POST /api/auth/login` - Login user
- `GET /api/auth/me` - Get current user (requires auth)

### Chats
- `POST /api/chat` - Send message and get AI response
- `GET /api/chats` - Get all user chats (max 10)
- `GET /api/chats/:chatId` - Get specific chat
- `DELETE /api/chats/:chatId` - Delete chat

All chat endpoints require authentication (JWT token in Authorization header).

## Project Structure

```
server/
├── models/          # MongoDB models (User, Chat)
├── controllers/      # Route controllers
├── routes/          # Express routes
├── middleware/       # Auth and error handling middleware
├── scripts/         # Utility scripts (seed user)
├── server.js        # Main server file
└── package.json
```

