import express from 'express';
import { 
  sendMessage, 
  getChats, 
  getChat, 
  deleteChat,
  getAvailableLawsList,
  updateChatLaw,
  updateChatMode
} from '../controllers/chatController.js';
import { authenticate } from '../middleware/auth.js';

const router = express.Router();

// All chat routes require authentication
router.use(authenticate);

router.post('/chat', sendMessage);
router.get('/chats', getChats);
router.get('/chats/:chatId', getChat);
router.delete('/chats/:chatId', deleteChat);
router.get('/laws', getAvailableLawsList);
router.patch('/chats/:chatId/law', updateChatLaw);
router.patch('/chats/:chatId/mode', updateChatMode);

export default router;

