import mongoose from 'mongoose';
import dotenv from 'dotenv';
import User from '../models/User.js';

dotenv.config();

const seedUser = async () => {
  try {
    // Connect to MongoDB
    await mongoose.connect(process.env.MONGODB_URI);
    console.log('✅ Connected to MongoDB');

    // Check if user already exists
    const existingUser = await User.findOne({ email: 'nadyahmd88@gmail.com' });
    
    if (existingUser) {
      console.log('ℹ️  User already exists:', existingUser.email);
      await mongoose.connection.close();
      process.exit(0);
    }

    // Create user
    const user = new User({
      email: 'nadyahmd88@gmail.com',
      password: 'user@123',
    });

    await user.save();
    console.log('✅ User created successfully:');
    console.log('   Email:', user.email);
    console.log('   Password: user@123');

    await mongoose.connection.close();
    process.exit(0);
  } catch (error) {
    console.error('❌ Error seeding user:', error);
    await mongoose.connection.close();
    process.exit(1);
  }
};

seedUser();

