import jwt from 'jsonwebtoken';
import User from '../models/User.js';

export const authenticate = async (req, res, next) => {
  try {
    const token = req.headers.authorization?.split(' ')[1] || 
                  req.cookies?.token;

    if (!token) {
      return res.status(401).json({ 
        error: 'غير مصرح. يرجى تسجيل الدخول.' 
      });
    }

    const decoded = jwt.verify(token, process.env.JWT_SECRET);
    const user = await User.findById(decoded.userId).select('-password');

    if (!user) {
      return res.status(401).json({ 
        error: 'المستخدم غير موجود.' 
      });
    }

    req.user = user;
    next();
  } catch (error) {
    if (error.name === 'JsonWebTokenError') {
      return res.status(401).json({ 
        error: 'رمز غير صالح.' 
      });
    }
    if (error.name === 'TokenExpiredError') {
      return res.status(401).json({ 
        error: 'انتهت صلاحية الرمز. يرجى تسجيل الدخول مرة أخرى.' 
      });
    }
    res.status(500).json({ 
      error: 'خطأ في المصادقة.' 
    });
  }
};

