export const errorHandler = (err, req, res, next) => {
  console.error('Error:', err);

  if (err.name === 'ValidationError') {
    return res.status(400).json({
      error: 'بيانات غير صحيحة.',
      details: Object.values(err.errors).map(e => e.message),
    });
  }

  if (err.name === 'MongoServerError' && err.code === 11000) {
    return res.status(400).json({
      error: 'البريد الإلكتروني مستخدم بالفعل.',
    });
  }

  res.status(err.status || 500).json({
    error: err.message || 'حدث خطأ في الخادم.',
  });
};

