import mongoose from 'mongoose';

const sourceSchema = new mongoose.Schema({
  law: {
    type: String,
    required: true,
  },
  article: {
    type: String,
    default: null,
  },
  filename: {
    type: String,
    default: null,
  },
}, { _id: false });

const messageSchema = new mongoose.Schema({
  text: {
    type: String,
    required: true,
  },
  sender: {
    type: String,
    enum: ['user', 'bot'],
    required: true,
  },
  timestamp: {
    type: Date,
    default: Date.now,
  },
  isError: {
    type: Boolean,
    default: false,
  },
  sources: {
    type: [sourceSchema],
    default: null,
  },
}, { _id: false });

const chatSchema = new mongoose.Schema({
  user: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true,
    index: true,
  },
  title: {
    type: String,
    default: null,
  },
  preview: {
    type: String,
    default: null,
  },
  selectedLaw: {
    type: String,
    default: null, // null means auto-detect from context
  },
  chatMode: {
    type: String,
    enum: [
      'general',           // عام
      'legal-advisor',     // مستشار قانوني
      'business-advisor',  // مستشار أعمال
      'legal-explainer',  // المفسر القانوني
      'contract-drafting', // صياغة العقود
      'risk-assessment',  // تحليل المخاطر
      'family-law',       // استشارات الأسرة
      'criminal-law'      // استشارات جنائية
    ],
    default: 'general',
  },
  messages: [messageSchema],
}, {
  timestamps: true,
});

// Index for efficient queries
chatSchema.index({ user: 1, createdAt: -1 });

export default mongoose.model('Chat', chatSchema);

